/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.yungnickyoung.minecraft.travelerstitles.init.TTModClient;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class DimensionTitleCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"dimensiontitle").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> DimensionTitleCommand.displayTitle((CommandSource)context.getSource(), DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension")))));
    }

    public static int displayTitle(CommandSource commandSource, ServerWorld world) {
        ResourceLocation dimensionBaseKey = world.func_234923_W_().func_240901_a_();
        String dimensionNameKey = Util.func_200697_a((String)"travelerstitles", (ResourceLocation)dimensionBaseKey);
        if (TTModClient.blacklistedDimensions.contains(dimensionBaseKey.toString())) {
            commandSource.func_197030_a((ITextComponent)new StringTextComponent("That dimension is blacklisted, so its title won't normally show!"), false);
        }
        TranslationTextComponent dimensionTitle = LanguageMap.func_74808_a().func_230506_b_(dimensionNameKey) ? new TranslationTextComponent(dimensionNameKey) : new StringTextComponent("???");
        String dimensionColorKey = dimensionNameKey + ".color";
        String dimensionColorStr = LanguageMap.func_74808_a().func_230506_b_(dimensionColorKey) ? LanguageMap.func_74808_a().func_230503_a_(dimensionColorKey) : TTModClient.dimensionTitleRenderer.titleDefaultTextColor;
        TTModClient.dimensionTitleRenderer.setColor(dimensionColorStr);
        TTModClient.dimensionTitleRenderer.displayTitle((ITextComponent)dimensionTitle, null);
        return 1;
    }
}

